#!/usr/bin/perl
# lun ago  8 14:37:00 CEST 2005
# author: Pedro Larroy Tovar
#
# This script creates a PCM Wav file as the result of dumping the audio
# from the video streams on the database, the Wav file is cut in smaller
# chunks in this case.
#
#    Copyright (C) Pedro Larroy Tovar piotr%NOSPAMlarroy.com

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#



use warnings;
use strict;
use File::Find;
use File::Copy;
use Getopt::Long;
use POSIX;

#######
# TUNABLES: 
#
# External program for dumping audio stream to a file
#  
#my $PROG='mplayer -ao pcm:file=XXXSTREAMXXX -vo null';
#
# Extension of the video streams
#
my $EXT='avi';
#
# Sound file size in bytes
#
my $FREQ=16000;
my $NFILES=4;
# Put this many sound samples per file
# my $MANY=23962;
#
#######

my %opt;

sub usage {
die<<EOT;
$0 usage:
	$0 [options] directory1 [directory2] ...

	options:
		--help		this screen
		--overwrite	overwrites the streams
		--verbose	shows mplayer output
		--fixheader option to fix the byte alignment field of the wav header
			in case unpatched mplayer is used (dirty! it only works for 16bit mono files)


EOT
}

sub disable_stdout {
	no warnings;
	open(OLDSTDOUT,">&STDOUT") or die "Open:$!";
	#open(OLDSTDERR,">&STDOUT") or die "Open:$!";
	open(FNULL,'>/dev/null') or die "open: $!";	
	#open(STDERR,">&FNULL") or die "open: $!";
	open(STDOUT,">&FNULL") or die "open: $!";

}

sub enable_stdout {
	no warnings;
	#close(STDERR) or die "close: $!";
	close(STDOUT) or die "close: $!";
	close(FNULL) or die "close: $!";
	#open(STDERR,">&OLDSTDERR") or die "open: $!";
	open(STDOUT,">&OLDSTDOUT") or die "open: $!";
}

sub audiodump {
	$_ = shift;
	die if (! -f $_);
	my @CMD = ('mplayer','-af','resample='.$FREQ.':0:2,channels=1','-ao','pcm:file=__dump__.wav','-vc','dummy','-vo','null',$_);			
	disable_stdout unless $opt{verbose};
	system(@CMD) == 0 or die $CMD[0].' exited with nonzero status';
	enable_stdout unless $opt{verbose};
	#
	# Fix wav header bug, probably on mplayer
	#
	if( $opt{fixheader} ) {
		open(WAV,"+<__dump__.wav") or die "open: $!";
		seek(WAV,0x20,0) or die "seek: $!";
		print WAV pack("c",2);
		close(WAV) or die "close: $!";
	}
	#

}

sub read_wav_length_samples {
	$_ = shift;
	my $data;

	die "read_wav_length_samples" if ( ! -f $_);
	open(FH,'<',$_) or die "open: $!";

	seek(FH,32,0) or die "seek: $!";
	read(FH,$data,2) or die "read: $!";
	my $ba=unpack("S",$data);

	seek(FH,34,0) or die "seek: $!";
	read(FH,$data,2) or die "read: $!";
	my $bits_s=unpack("S",$data);

	seek(FH,40,0) or die "seek: $!";
	read(FH,$data,4) or die "read: $!";
	my $length_b=unpack("I",$data);

	close(FH);
	return ($length_b/($bits_s/8));
}

sub found {
	if ( -f $_ && m/(.*)\.\Q$EXT\E$/ ) {
		my $videofile = $_;
		if ( -r $_ ) {
			my $prefix = $1;
			my @audiofiles=<*.wav>;
			my @match = grep( /^\Q$prefix\E-\d+\.wav$/, @audiofiles);
			if (@match) {
				warn "$_ is already done, won't do anything here without --overwrite\n";
				return if (!$opt{overwrite});
			}
			audiodump($videofile);
			my $total_samples = read_wav_length_samples('__dump__.wav');
			my $MANY = floor($total_samples/$NFILES);
			print "\n$videofile : $total_samples sound samples\n$NFILES files\n\n";
			my $nlen = length(ceil($total_samples/$MANY));
			for(my $start=0,my $i=0;($start+$MANY)<$total_samples;$start+=$MANY,$i++) {
				my $dumpfile = $prefix.'-'.sprintf("%0".$nlen."d",$i).'.wav';
				print "$videofile to dumpfile $dumpfile\n";
				if ( ! -f $dumpfile || $opt{overwrite} ) {
					my @CMD = ('sox','__dump__.wav',$dumpfile,'trim',$start."s",$MANY."s");			
					#print join(' ',@CMD)."\n";
					print "trimming to $dumpfile... ";
					disable_stdout unless $opt{verbose};
					system(@CMD) == 0 or die $CMD[0].' exited with nonzero status';
					enable_stdout unless $opt{verbose};

					#
					# Fix wav header bug, probably on mplayer
					#
					if( $opt{fixheader} ) {
						open(WAV,"+<__dump__.wav") or die "open: $!";
						seek(WAV,0x20,0) or die "seek: $!";
						print WAV pack("c",2);
						close(WAV) or die "close: $!";
					}
					#
					#move("__dump__.wav",$dumpfile) or die "move: $!";
				} else {
					warn $dumpfile.": file exists, skipping (use --overwrite to force overwritting";
				}
			}	
			unlink("__dump__.wav") or die "unlink: $!";
		} else {
			warn $videofile.": not readable";
		}
	}
}

GetOptions(
	'help' => \$opt{help},
	'verbose' => \$opt{verbose},
	'overwrite' => \$opt{overwrite},
	'fixheader' => \$opt{fixheader},
) or usage;
usage if $opt{help};

if ( ! @ARGV ) {
	usage();
}
foreach my $arg (@ARGV) {
	if ( ! -d $arg ) {
		die "$arg: not a directory, see usage";
	}
}

find(\&found,@ARGV);




